package com.instabug.library.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.TypedValue;

import com.instabug.library.R;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;

/**
 * @author mSobhy
 */
public class AttrResolver {

    public static
    @DrawableRes
    int getDrawableResourceId(Context context, int attributeToResolve) {
        TypedValue typedValueAttr = new TypedValue();

        context.getTheme().resolveAttribute(attributeToResolve, typedValueAttr, true);
        return typedValueAttr.resourceId;
    }

    @ColorInt
    public static int getTintingColor(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.instabug_theme_tinting_color, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getBackgroundColor(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.instabug_background_color, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getDividerColor(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.instabug_divider_color, typedValue, true);
        return typedValue.data;
    }

    public static int getDialogItemTextColor(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.instabug_dialog_item_text_color, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int resolveAttributeColor(@NonNull Context context, @AttrRes int attribute) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(attribute, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getColor(@NonNull Context context, int attributeToResolve) {
        int[] attribute = new int[]{attributeToResolve};
        TypedArray array = context.getTheme().obtainStyledAttributes(attribute);
        int color = array.getColor(0, Color.TRANSPARENT);
        array.recycle();
        return color;
    }
}
