package com.instabug.library.sessionreplay.model

import com.instabug.library.sessionreplay.di.SessionReplayServiceLocator
import com.instabug.library.sessionreplay.model.SessionMetadata.LaunchType
import com.instabug.library.sessionreplay.model.SessionMetadata.NetworkLog

fun interface SessionMetadataCustomizer {
    fun customize(builder: SessionMetadata.Builder)
}

sealed class SRData : SessionMetadataCustomizer {
    class ApmSRMetadata(
        @LaunchType val launchType: String? = null,
        val launchDuration: Long? = null,
        val networkLogs: List<NetworkLog>? = null
    ) : SRData() {
        override fun customize(builder: SessionMetadata.Builder) {
            builder.launchType = launchType
            builder.launchDuration = launchDuration
            if (SessionReplayServiceLocator.srConfigurationsProvider.networkLogsEnabled)
                builder.networkLogs = networkLogs
        }
    }
}
