package com.instabug.library.sessioncontroller

import com.instabug.library.SessionManager
import com.instabug.library.core.InstabugCore
import com.instabug.library.internal.sharedpreferences.corePref
import com.instabug.library.model.v3Session.SessionEvent
import com.instabug.library.sessionV3.di.IBGSessionServiceLocator
import com.instabug.library.sessionV3.manager.IBGSessionManager
import org.json.JSONObject

internal interface SessionManualControllerConfigs {

    /**
     * Represents the remote config for whether control session manually feature enabled or disabled.
     */
    var controlSessionManuallyEnabled: Boolean

    fun handle(featuresRequest: JSONObject?)

}

internal object SessionManualControllerConfigsImpl : SessionManualControllerConfigs {

    private const val CONTROL_SESSION_MANUALLY_REMOTE_KEY: String = "control_session_manually"
    private const val CONTROL_SESSION_MANUALLY_PREFS_KEY: String = "ibg_control_session_manually"
    private const val CONTROL_SESSION_MANUALLY_DEFAULT_VALUE: Boolean = false

    override var controlSessionManuallyEnabled: Boolean by corePref(
        CONTROL_SESSION_MANUALLY_PREFS_KEY, CONTROL_SESSION_MANUALLY_DEFAULT_VALUE
    )

    override fun handle(featuresRequest: JSONObject?) {
        val controlSessionManuallyState = featuresRequest?.optBoolean(
            CONTROL_SESSION_MANUALLY_REMOTE_KEY, CONTROL_SESSION_MANUALLY_DEFAULT_VALUE
        ) ?: CONTROL_SESSION_MANUALLY_DEFAULT_VALUE

        val oldControlSessionManuallyState = controlSessionManuallyEnabled

        controlSessionManuallyEnabled = controlSessionManuallyState

        //Handle first session
        if (controlSessionManuallyState != oldControlSessionManuallyState
            && !oldControlSessionManuallyState //Last state was disabled
            && InstabugCore.getRunningSession() != null
        ) {
            SessionManualController.stopSession()
        } else if (controlSessionManuallyState != oldControlSessionManuallyState
            && oldControlSessionManuallyState //Last state was enabled
            && InstabugCore.getRunningSession() == null
        ) {
            SessionManager.getInstance().handleSessionStartEvent()
            IBGSessionManager emit SessionEvent.Start()
        }

    }

}