package com.instabug.library.networkv2.request

import com.instabug.library.model.State
import com.instabug.library.settings.SettingsManager
import com.instabug.library.tokenmapping.TokenMappingServiceLocator
import com.instabug.library.util.InstabugDateFormatter

private const val KEY_DELAY_REPORTED_AT = "connection_delay_reported_at"

@JvmName("getTokenFromState")
fun Request.Builder.getTokenFromState(state: State?): Request.Builder {

    val token = when {
        state != null && state.appToken != null -> state.appToken
        state != null && state.appToken == null -> SettingsManager.getInstance().appToken
        else -> TokenMappingServiceLocator.getTokenMappingConfigs().availableAppToken
    }

    tokenProvider(object : AppTokenProvider {
        override fun getAppToken(): String? = token
    })

    return this
}

@JvmName("updateDelayedReportedAt")
fun Request.updateDelayedReportedAt(): Request {
    return if (isReportBugRequest() ) {
        builder().addParameter(RequestParameter(KEY_DELAY_REPORTED_AT,
            InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds())).build()
    } else this
}

fun Request.isReportBugRequest() = endpoint == Endpoints.REPORT_BUG


