package com.instabug.library.networkv2;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.IBGNetworkWorker;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestType;

public interface INetworkManager {

    /**
     * Executes the request after being built and wrapped in the connection manager
     */
    @WorkerThread
    void doRequest(@IBGNetworkWorker String workerThread, @RequestType int requestType,
                   @NonNull Request request,
                   Request.Callbacks<RequestResponse, Throwable> reportingBugCallbacks);

    /**
     * Executes the request after being built and wrapped in the connection manager
     */
    @WorkerThread
    void doRequestOnSameThread(@RequestType int requestType,
                               @NonNull Request request,
                               Request.Callbacks<RequestResponse, Throwable> reportingBugCallbacks);

    /**
     * Executes the request after being built and wrapped in the connection manager
     * With the option to force sending the request regardless of online state
     */
    @WorkerThread
    void doRequestOnSameThread(@RequestType int requestType,
                               @NonNull Request request,
                               boolean onlineOverride,
                               Request.Callbacks<RequestResponse, Throwable> reportingBugCallbacks);

    void setOnDoRequestListener(@Nullable NetworkManager.OnDoRequestListener onDoRequestListener);

    @Nullable
    NetworkManager.OnDoRequestListener getOnDoRequestListener();
}
