package com.instabug.library.logging.listeners.networklogs

/**
 * This class is responsible and should be used only for exposing the captured networkLogs that
 * can be modified before it got inserted in the database.
 *
 * You can view any field value as well as modifying it.
 * Any modification on class members values are applied on the captured networkLogs.
 */
data class NetworkLogSnapshot(
    var url: String?,
    var requestHeaders: MutableMap<String, Any?>?,
    var requestBody: String?,
    var responseHeaders: MutableMap<String, Any?>?,
    var response: String?,
    val responseCode: Int
)