package com.instabug.library.internal.video

import com.instabug.library.Constants
import com.instabug.library.util.InstabugSDKLogger

object ScreenRecordingServiceEventBus {
    private val eventHandlers = HashMap<String, EventHandlerWithData>()


    @JvmStatic
    fun registerHandler(eventName: String, eventHandler: EventHandlerWithData) {
        eventHandlers[eventName] = eventHandler
    }

    @JvmStatic
    fun postEvent(eventName: String, data: ScreenRecordingServiceData) {
        val handler = eventHandlers[eventName]
        try {
            handler?.handleEventWithData(data)
        } catch (e: Exception) {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "Something went wrong while post event " + e.message
            )
        }
    }

    @JvmStatic
    fun unregisterHandler(eventName: String) {
        eventHandlers.remove(eventName)
    }
}

interface EventHandlerWithData {
    fun handleEventWithData(data: ScreenRecordingServiceData)
}
