package com.instabug.library.internal.storage.operation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class WriteStateToFileDiskOperation implements DiskOperation<Uri, Context> {

    private final String stringState;
    private final File file;

    public WriteStateToFileDiskOperation(File file, String stringState) {
        this.stringState = stringState;
        this.file = file;
    }

    @Override
    public synchronized Uri execute(Context context) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        boolean newFile = file.createNewFile();
        if (!newFile) {
            InstabugSDKLogger.v(Constants.LOG_TAG, "State file: " + file.getAbsolutePath() + "already exists");
        }
        OutputStreamWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(file, false);
            writer = new OutputStreamWriter(out, Charset.forName("UTF8"));
            writer.write(stringState);
        } finally {
            if (writer != null) {
                writer.close();
            }
        }
        return Uri.fromFile(file);
    }

    @Override
    public void executeAsync(Context context, @Nullable final DiskOperationCallback<Uri> callback) {
        PoolProvider.postIOTask(new Runnable() {
            @Override
            public void run() {
                try {
                    write();
                } catch (Throwable throwable) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Error while writing state file" + throwable.getMessage());
                    if (callback != null) {
                        callback.onFailure(throwable);
                    }
                }
                if (callback != null) {
                    callback.onSuccess(Uri.fromFile(file));
                }
            }

            @SuppressLint("RESOURCE_LEAK")
            private void write() throws Throwable {
                boolean newFile = file.createNewFile();
                if (!newFile) {
                    InstabugSDKLogger.v(Constants.LOG_TAG, "State file" + file.getAbsolutePath() + "already exists");
                }
                FileOutputStream out = new FileOutputStream(file, false);
                OutputStreamWriter writer = new OutputStreamWriter(out, Charset.forName("UTF8"));
                writer.write(stringState);
                writer.close();
            }
        });
    }
}
