package com.instabug.library.internal.storage.cache.user;

import androidx.annotation.NonNull;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugFeaturesManager;
import com.instabug.library.model.User;

public class UserCacheManager {

    public static void insertUser(@NonNull String uuid, int sessionCount) {
        User user = new User(uuid, sessionCount, getLastSeen(uuid));
        UserDbHelper.insert(user);
    }

    public static int getUserSessionCount(@NonNull String uuid) {
        User retrievedUser = UserDbHelper.retrieve(uuid);
        return retrievedUser != null ? retrievedUser.getSessionCount() : 0;
    }

    private static long getLastSeen(@NonNull String uuid) {
        User retrievedUser = UserDbHelper.retrieve(uuid);
        return retrievedUser != null ? retrievedUser.getLastSeen() : 0;
    }

    public static void updateSessionCount(@NonNull String uuid, int sessionCount) {
        UserDbHelper.update(new User(uuid, sessionCount, getLastSeen(uuid)));
    }

    public static void updateLastSeen(@NonNull String uuid, long lastSeen) {
        UserDbHelper.update(new User(uuid, getUserSessionCount(uuid), lastSeen));
    }

    public static void insertIfNotExists(String uuid, int sessionCount) {
        if (UserDbHelper.retrieve(uuid) == null
                && InstabugFeaturesManager.getInstance().getFeatureState(IBGFeature.INSTABUG) == Feature.State.ENABLED) {
            insertUser(uuid, sessionCount);
        }
    }
}
