package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.Cursor
import android.database.sqlite.SQLiteDatabase
import com.instabug.library.Constants
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.util.InstabugSDKLogger

class DBDestructiveMigration(private val db: SQLiteDatabase) {

    fun migrate() {
        try {
            DiskUtils.deleteAllStateFiles()
            DiskUtils.deleteSessionReplayDirectory()
            DiskUtils.cleanseSRMonitoringDirectory()
            dropAllTables()
            createDBTables()
        } catch (e: Exception) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Failed running destructive migration")
        }
    }

    private fun dropAllTables() {
        var cursor: Cursor? = null
        try {
            cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null)
            val tables: MutableList<String> = ArrayList(cursor.count)
            while (cursor.moveToNext()) {
                tables.add(cursor.getString(0))
            }
            for (table in tables) {
                if (table.startsWith("sqlite_")) {
                    continue
                }
                db.execSQL("DROP TABLE IF EXISTS $table")
                InstabugSDKLogger.v(Constants.LOG_TAG, "Dropped table $table")
            }
        } catch (e: Exception) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "error dropping DB tables")
        } finally {
            cursor?.close()
        }
    }

    fun createDBTables() {
        db.apply {
            execSQL(IBGDbContract.BugEntry.CREATE_TABLE)
            execSQL(IBGDbContract.FatalHangEntry.CREATE_TABLE)
            execSQL(IBGDbContract.AppTerminationEntry.CREATE_TABLE)
            execSQL(IBGDbContract.SessionEntry.CREATE_TABLE)
            execSQL(IBGDbContract.SessionExperimentEntry.CREATE_TABLE)
            execSQL(IBGDbContract.SessionIncidentEntry.CREATE_TABLE)
            execSQL(IBGDbContract.SessionReplayMetadataEntry.CREATE_TABLE)
            execSQL(IBGDbContract.FeaturesFlagsEntry.CREATE_TABLE_QUERY)
            execSQL(IBGDbContract.SessionFeaturesFlagsEntry.CREATE_TABLE)
        }
    }
}