package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.*
/**
 * Drops Analytics table if exists
 * Create APM Experiment table
 */
class Migration_34_35 : Migration {

    override fun migrate(database: SQLiteDatabase?) {
        database?.let { db ->
            db.execSQL(APMExperimentEntry.CREATE_TABLE_QUERY)
            db.execSQL(
                "ALTER TABLE ${APMSessionMetaDataEntry.TABLE_NAME} "
                        + "ADD COLUMN ${APMSessionMetaDataEntry.COLUMN_EXPERIMENTS_COUNT} "
                        + "$INTEGER_TYPE DEFAULT ${APMSessionMetaDataEntry.COUNT_DEFAULT_VALUE}"
            )
            // Drop SDK Analytics Table
            db.execSQL(SDKApiEntry.DROP_TABLE)
            db.execSQL(SDKEventEntry.DROP_TABLE)
        }

    }
}