package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * A Migration is used to perform the migration of one database schema to another.
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 */
@FunctionalInterface
public interface Migration {

    /**
     * This method will be called if a migration is needed. The entire method is wrapped in a
     * write transaction so it is possible to create, update or delete any existing tables
     * without wrapping it in your own transaction.
     *
     * @param db the database
     */
    void migrate(SQLiteDatabase db);
}
