package com.instabug.library.internal.storage.cache.db.contract.apm

import com.instabug.library.diagnostics.diagnostics_db.INTEGER_TYPE
import com.instabug.library.diagnostics.diagnostics_db.TEXT_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.AUTO_INCREMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.COMMA_SEP
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CONSTRAINT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CREATE_TABLE_STATEMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DELETE_FROM
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DROP_STATEMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.FOREIGN_KEY
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.ON_DELETE_CASCADE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.PRIMARY_KEY
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.REFERENCES

object ApmAppFlowTableAttributeEntry {

    const val TABLE_NAME = "apm_flow_attribute"

    const val COLUMN_ID = "id"
    const val COLUMN_FLOW_ID = "flow_id"
    const val COLUMN_KEY = "key"
    const val COLUMN_VALUE = "value"

    val CREATE_TABLE_QUERY: String
        get() =
            "$CREATE_TABLE_STATEMENT$TABLE_NAME ( " +
                    "$COLUMN_ID$INTEGER_TYPE$PRIMARY_KEY$AUTO_INCREMENT$COMMA_SEP" +
                    "$COLUMN_FLOW_ID$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_KEY$TEXT_TYPE$COMMA_SEP" +
                    "$COLUMN_VALUE$TEXT_TYPE$COMMA_SEP" +
                    "$CONSTRAINT$COLUMN_FLOW_ID" +
                    "$FOREIGN_KEY($COLUMN_FLOW_ID) $REFERENCES" +
                    "${ApmAppFlowEntry.TABLE_NAME}(${ApmAppFlowEntry.COLUMN_ID}) " +
                    "$ON_DELETE_CASCADE )"

    val DROP_TABLE_QUERY: String get() = "$DROP_STATEMENT$TABLE_NAME"
    val DELETE_ALL: String get() = "$DELETE_FROM$TABLE_NAME"
}