package com.instabug.library.instacapture.screenshot.pixelcopy;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.util.Pair;
import android.view.Display;

import androidx.annotation.NonNull;

import com.instabug.library.util.ScreenUtility;

/**
 * Class that holds display info used with pixelCopy to capture screenshot
 */
public class DisplaySpecs {
    public int width;
    public int height;

    public DisplaySpecs(@NonNull Activity activity) {
        if (activity == null) return;

        if (activity.getWindowManager().getDefaultDisplay() == null) return;

        if (activity.getResources() == null) return;

        if (activity.getResources().getDisplayMetrics() == null) return;

        Display display = activity.getWindowManager().getDefaultDisplay();
        Point displaySize = getDisplaySize(display);
        int widthCutout = 0;
        Pair<Integer, Integer> edgesCutout = ScreenUtility.getEdgesCutoutIfApplicable(activity);
        if (edgesCutout != null) {
            widthCutout = edgesCutout.first + edgesCutout.second;
        }
        width = displaySize.x - widthCutout;
        height = displaySize.y;
    }


    private Point getDisplaySize(@NonNull Display display) {
        Point point = new Point();
        if (display == null) return point;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            display.getRealSize(point);
        } else {
            display.getSize(point);
        }
        return point;
    }
}
