package com.instabug.library.instacapture.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;

import androidx.annotation.IdRes;
import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by tarek on 5/18/16.
 */
public class FieldHelper {

    private final static String FIELD_NAME_WINDOW_MANAGER = "mWindowManager";
    private final static String FIELD_NAME_GLOBAL = "mGlobal";
    private final static String FIELD_NAME_ROOTS = "mRoots";
    private final static String FIELD_NAME_PARAMS = "mParams";
    private final static String FIELD_NAME_VIEW = "mView";
    private static final int[] outLocation = new int[2];

    private FieldHelper() {
    }

    public static List<RootViewInfo> getRootViews(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        List<RootViewInfo> rootViews = new ArrayList<>();

        Object windowManager;
        Object rootObjects;
        Object paramsObject;

        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                windowManager = getFieldValue(FIELD_NAME_GLOBAL, activity.getWindowManager());
            } else {
                windowManager = getFieldValue(FIELD_NAME_WINDOW_MANAGER, activity.getWindowManager());
            }

            rootObjects = getFieldValue(FIELD_NAME_ROOTS, windowManager);
            paramsObject = getFieldValue(FIELD_NAME_PARAMS, windowManager);

        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Can't fine one of " +
                    "(WindowManager, rootObjects, paramsObject) field name so screenshot " +
                    "capturing failed", e);
            return rootViews;
        }

        Object[] viewRoots = null;
        WindowManager.LayoutParams[] params = null;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            if (rootObjects != null) {
                viewRoots = ((List<?>) rootObjects).toArray();
            }
            List<WindowManager.LayoutParams> paramsList = (List<WindowManager.LayoutParams>) paramsObject;
            if (paramsList != null) {
                int paramsListSize = paramsList.size();
                params = paramsList.toArray(new WindowManager.LayoutParams[paramsListSize]);
            }
        } else {
            viewRoots = (Object[]) rootObjects;
            params = (WindowManager.LayoutParams[]) paramsObject;
        }

        if (viewRoots != null) {
            for (int i = 0; i < viewRoots.length; i++) {
                try {

                    View view = (View) getFieldValue(FIELD_NAME_VIEW, viewRoots[i]);

                    boolean shouldIgnore = false;
                    if (ignoredViewsIds != null) {
                        for (int ignoredViewId : ignoredViewsIds) {
                            if (view != null && ignoredViewId == view.getId()) {
                                shouldIgnore = true;
                            }
                        }
                    }

                    if (view != null && view.getVisibility() == View.VISIBLE && !shouldIgnore && params != null) {
                        rootViews.add(new RootViewInfo(view, getViewRect(view), params[i]));
                    }

                } catch (Exception e) {
                    InstabugSDKLogger.e(Constants.LOG_TAG,
                            "Screenshot capturing failed in one of the viewRoots", e);
                }

            }
        }

        return rootViews;
    }

    private static Rect getViewRect(View view) {
        view.getLocationOnScreen(outLocation);
        int left = outLocation[0];
        int top = outLocation[1];
        return new Rect(left, top, left + view.getWidth(), top + view.getHeight());
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    private static Object getFieldValue(String fieldName, Object target) throws NoSuchFieldException, IllegalAccessException {
        Field field;
        if (fieldName.equals(FIELD_NAME_WINDOW_MANAGER)) {
            field = findField(fieldName, target.getClass());
        } else {
            field = target.getClass().getDeclaredField(fieldName);
        }
        field.setAccessible(true);
        return field.get(target);
    }

    public static Field findField(String name, Class clazz) throws NoSuchFieldException {
        Class currentClass = clazz;
        while (currentClass != null && currentClass != Object.class) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (name.equals(field.getName())) {
                    return field;
                }
            }

            currentClass = currentClass.getSuperclass();
        }

        throw new NoSuchFieldException(
                "Field: " + name + " is not found in class: " + clazz.toString());
    }
}