package com.instabug.library.encryption

import android.content.Context
import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.internal.contentprovider.InstabugApplicationProvider

object EncryptionPreferences {

    const val ENCRYPTION_PREF_NAME = "IB_Encryption"
    private const val IB_ENCRYPTION_KEY = "ib_encryption_key"
    private const val IB_ENCRYPTION_IV = "ib_encryption_iv"

    private var sharedPreferences: SharedPreferences? = null
    private var editor: SharedPreferences.Editor? = null

    init {
        InstabugApplicationProvider.getInstance()?.application?.let {
            sharedPreferences = it.getSharedPreferences(ENCRYPTION_PREF_NAME, Context.MODE_PRIVATE)
            editor = sharedPreferences!!.edit()
        }
    }

    fun saveEncryptionKey(key: String) {
        editor?.let {
            it.putString(IB_ENCRYPTION_KEY, key)
            it.apply()
        }
    }

    fun getEncryptionKey(): String {
        return sharedPreferences?.getString(IB_ENCRYPTION_KEY, "") ?: ""
    }

    fun saveEncryptionIV(iv: String) {
        editor?.let {
            it.putString(IB_ENCRYPTION_IV, iv)
            it.apply()
        }
    }

    fun getEncryptionIV(): String {
        return sharedPreferences?.getString(IB_ENCRYPTION_IV, "") ?: ""
    }
}