package com.instabug.library.diagnostics.nonfatals.model;

import static com.instabug.library.diagnostics.nonfatals.model.NonFatal.Priority.HIGH;
import static com.instabug.library.diagnostics.nonfatals.model.NonFatal.Priority.NORMAL;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.model.State;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Shannan on 29/08/2021.
 */
public class NonFatal {

    private long id = -1;
    @Nullable
    private String exceptionType;
    @Nullable
    private String declaringClass;
    @Nullable
    private String methodName;
    @Nullable
    private String fileName;
    private int lineNumber;
    @Nullable
    private State state;
    @NonNull
    private List<Occurrence> occurrences = new ArrayList<>();
    @NonNull
    private String message = "";
    @Nullable
    private String stackTrace;

    @Priority
    private int priority = NORMAL;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public String getExceptionType() {
        return exceptionType;
    }

    public void setExceptionType(@Nullable String exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Nullable
    public String getDeclaringClass() {
        return declaringClass;
    }

    public void setDeclaringClass(@Nullable String declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Nullable
    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(@Nullable String methodName) {
        this.methodName = methodName;
    }

    @Nullable
    public String getFileName() {
        return fileName;
    }

    public void setFileName(@Nullable String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Nullable
    public State getState() {
        return state;
    }

    public void setState(@Nullable State state) {
        this.state = state;
    }

    @NonNull
    public List<Occurrence> getOccurrences() {
        return occurrences;
    }

    public void setOccurrences(@NonNull List<Occurrence> occurrences) {
        this.occurrences = occurrences;
    }

    public void addOccurrence(Occurrence occurrence) {
        if (occurrence == null) {
            occurrences = new ArrayList<>();
        }
        occurrences.add(occurrence);
    }

    @NonNull
    public String getMessage() {
        return message;
    }

    public void setMessage(@NonNull String message) {
        this.message = message;
    }

    @Nullable
    public String getStackTrace() {
        return stackTrace;
    }

    public void setStackTrace(@Nullable String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Priority
    public int getPriority() {
        return priority;
    }

    public void setPriority(@Priority int priority) {
        this.priority = priority;
    }

    @IntDef({NORMAL, HIGH})
    @Retention(RetentionPolicy.RUNTIME)
    public @interface Priority {
        int NORMAL = 0;
        int HIGH = 1;
    }
}
