package com.instabug.library.coreSDKChecks

import com.instabug.library.BuildConfig
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent
import com.instabug.library.settings.SettingsManager

class CurrentSDKVersionChangeHandler(private val settingsManager: SettingsManager?) {
    fun setCurrentSdkVersion(inputSdkVersion: String) {
        settingsManager?.run {
            if (lastSDKVersion != null && lastSDKVersion != inputSdkVersion)
                IBGCoreEventPublisher.post(IBGSdkCoreEvent.SdkVersionChanged)
            setCurrentSDKVersion(BuildConfig.SDK_VERSION)
        }
    }
}