package com.instabug.library.core.eventbus.eventpublisher

import com.instabug.library.Constants.LOG_TAG
import com.instabug.library.diagnostics.IBGDiagnostics

/*this interface to inject other exception handler while testing */
fun interface IBGEventBusExceptionHandler {
    fun runDefensive(action: () -> Unit)
}

object IBGEventBusExceptionHandlerImpl : IBGEventBusExceptionHandler {
    override fun runDefensive(action: () -> Unit) {
        try {
            action()
        } catch (e: Exception) {
            IBGDiagnostics.reportNonFatalAndLog(e, e.message ?: "", LOG_TAG)
        }
    }
}