package com.instabug.library.broadcast;


import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class SDKInvokedBroadcast extends BroadcastReceiver {
    //Public static String represent onSDKInvoked action for local broadcasts.
    public static final String SDK_INVOKED = "SDK invoked";
    //Public static String key for SDK invoking state.
    public static final String SDK_INVOKED_STATE = "SDK invoking state";
    /**
     * SDIInvokedListener {@link SDKInvokedBroadcast.SDIInvokedListener} instance received from caller.
     * Using in notifying caller when SDK invoking state changed.
     */
    private SDIInvokedListener mSDIInvokedListener;

    public SDKInvokedBroadcast(SDIInvokedListener mSDIInvokedListener) {

        this.mSDIInvokedListener = mSDIInvokedListener;

    }

    /**
     * This method is called when the BroadcastReceiver is receiving an Intent broadcast.
     * <p/>
     *
     * @param context The Context in which the receiver is running.
     * @param intent  The Intent being received.
     */
    //[START - on_receive]
    @Override
    public void onReceive(Context context, Intent intent) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "SDK invoked broadcast received");
        if (intent.getExtras() != null) {
            boolean isSDKInvoked = intent.getExtras().getBoolean(SDK_INVOKED_STATE);
            mSDIInvokedListener.onSDKInvoked(isSDKInvoked);
        }

    }//[END - on_receive]

    public interface SDIInvokedListener {

        void onSDKInvoked(boolean isInvoked);
    }
}