package com.instabug.library;

public interface OnSdkDismissCallback {
    /**
     * Called when Instabug SDK is dismissed providing relevant information
     *
     * @param issueState whether bug/feedback was submitted, cancelled or in_progress
     * @param reportType the submitted report type
     */
    void call(DismissType issueState, ReportType reportType);

    enum DismissType {
        /**
         * Indicates that the issue was submitted and to be uploaded
         */
        SUBMIT,
        /**
         * Indicates that the user cancelled the SDK without submission
         */
        CANCEL,
        /**
         * Indicates that the issue reporting scenario is in progress (taking another screenshot from app, etc...)
         */
        ADD_ATTACHMENT
    }


    enum ReportType {
        BUG("bug"), FEEDBACK("feedback"), QUESTION("question"), FRUSTRATING_EXPERIENCE("frustrating experience"),OTHER("other");
        private final String name;

        ReportType(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return name;
        }
    }
}
