/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.util.SystemServiceUtils;
import com.instabug.library.util.ThemeApplier;

public abstract class ToolbarFragment<P extends BaseContract.Presenter>
extends InstabugBaseFragment<P> {
    @Nullable
    protected ImageButton toolbarImageButtonDone;
    @Nullable
    protected ImageButton toolbarImageButtonClose;
    @Nullable
    private View instabugToolbar;
    @Nullable
    private TextView titleTextView;

    private void initToolbarViews() {
        ToolbarFragment toolbarFragment = this;
        toolbarFragment.toolbarImageButtonDone = (ImageButton)toolbarFragment.findViewById(R.id.instabug_btn_toolbar_right);
        toolbarFragment.instabugToolbar = toolbarFragment.findViewById(R.id.instabug_toolbar);
        toolbarFragment.titleTextView = (TextView)toolbarFragment.findViewById(R.id.instabug_fragment_title);
        ImageButton imageButton = toolbarFragment.toolbarImageButtonDone;
        if (imageButton != null) {
            imageButton.setOnClickListener(v2 -> {
                FragmentActivity fragmentActivity = this.getActivity();
                if (fragmentActivity != null) {
                    SystemServiceUtils.hideInputMethod((Activity)fragmentActivity);
                }
                this.onDoneButtonClicked();
            });
        }
        this.toolbarImageButtonClose = imageButton = (ImageButton)this.findViewById(R.id.instabug_btn_toolbar_left);
        if (imageButton != null) {
            imageButton.setOnClickListener(v2 -> this.onCloseButtonClicked());
        }
        this.styleToolbar();
    }

    private void styleToolbar() {
        View view = this.instabugToolbar;
        if (view != null) {
            view.setBackgroundColor(InstabugCore.getPrimaryColor());
        }
        ThemeApplier.applyTitleStyle(this.titleTextView, this.getIBGTheme());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @CallSuper
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        ToolbarFragment toolbarFragment = this;
        toolbarFragment.initToolbarViews();
        ViewStub viewStub = (ViewStub)toolbarFragment.findViewById(R.id.instabug_content);
        if (viewStub != null) {
            ViewStub viewStub2 = viewStub;
            viewStub2.setLayoutResource(this.getContentLayout());
            viewStub2.inflate();
        }
        ToolbarFragment toolbarFragment2 = this;
        toolbarFragment2.initContentViews((View)var1_1, (Bundle)var2_2);
        toolbarFragment2.setTitle(toolbarFragment2.getTitle());
        ThemeApplier.setScreenBackground((View)var1_1, toolbarFragment2.getIBGTheme());
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_fragment_toolbar;
    }

    @LayoutRes
    protected abstract int getContentLayout();

    protected abstract void initContentViews(View var1, @Nullable Bundle var2);

    /*
     * WARNING - void declaration
     */
    protected void setTitle(String title) {
        if (this.rootView == null) {
            return;
        }
        if ((this = (TextView)this.findViewById(R.id.instabug_fragment_title)) != null) {
            void var1_1;
            this.setText((CharSequence)var1_1);
        }
    }

    protected abstract String getTitle();

    protected abstract void onDoneButtonClicked();

    protected void onCloseButtonClicked() {
        if ((this = this.getActivity()) != null) {
            ToolbarFragment toolbarFragment = this;
            SystemServiceUtils.hideInputMethod((Activity)toolbarFragment);
            toolbarFragment.onBackPressed();
        } else {
            Log.w((String)"ToolbarFragment", (String)"onCloseButtonClicked can't be executed due to null getActivity() reference");
        }
    }

    @Nullable
    protected IBGTheme getIBGTheme() {
        Object p2 = this.presenter;
        return p2 != null && p2.getTheme() != null ? this.presenter.getTheme() : null;
    }
}

