/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apichecker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.apichecker.a;
import com.instabug.library.apichecker.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class APIChecker {
    public static final String NOT_BUILT_ERROR_MESSAGE = "Instabug API {%s} was called before the SDK is built. To build it, please call Instabug.Builder().build().";
    public static final String MAIN_THREAD_ERROR_MESSAGE = "Threading violation: {%s} should only be called from a background thread, but was called from main thread.";
    public static final String NOT_ENABLED_ERROR_MESSAGE = "Instabug API {%s} was called while the SDK is disabled. To enable it, please call Instabug.enable().";
    public static final String NOT_EXECUTED_ERROR_MESSAGE = "Instabug failed to execute {%s}";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T checkAndGet(@NonNull String apiName, @NonNull ReturnableRunnable<T> runnable, @Nullable T fallbackValue) {
        void var2_2;
        String string;
        void var1_1;
        APIChecker.checkMainThreadCalls(apiName);
        return (T)PoolProvider.getApiExecutor().executeAndGet(() -> APIChecker.lambda$checkAndGet$0((ReturnableRunnable)var1_1, string, var2_2));
    }

    private static void checkMainThreadCalls(String apiName) {
        if (Thread.currentThread().getName().equals("main")) {
            String string;
            APIChecker.logMainThreadWarning(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRunInExecutor(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string;
        void var1_1;
        PoolProvider.getApiExecutor().execute(() -> APIChecker.lambda$checkAndRunInExecutor$1((VoidRunnable)var1_1, string));
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRunInExecutorThenPostOnMain(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string;
        void var1_1;
        PoolProvider.getApiExecutor().execute(() -> APIChecker.lambda$checkAndRunInExecutorThenPostOnMain$3((VoidRunnable)var1_1, string));
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRunOrThrow(@NonNull String apiName, @NonNull VoidRunnable runnable) throws Exception {
        a a22;
        String string;
        block5: {
            b b22;
            block4: {
                try {
                    void var1_1;
                    APIChecker.checkBuilt();
                    APIChecker.checkEnabled();
                    PoolProvider.getApiExecutor().execute(() -> APIChecker.lambda$checkAndRunOrThrow$4((VoidRunnable)var1_1, string));
                    return;
                }
                catch (Exception exception) {
                }
                catch (b b22) {
                    break block4;
                }
                catch (a a22) {
                    break block5;
                }
                APIChecker.logExecutionException(string, exception);
                throw exception;
            }
            APIChecker.logSdkNotEnabled(string);
            throw b22;
        }
        APIChecker.logSdkNotBuilt(string);
        throw a22;
    }

    public static void checkAndRun(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        block4: {
            String string;
            block6: {
                block5: {
                    try {
                        APIChecker.checkBuilt();
                        APIChecker.checkEnabled();
                        runnable.run();
                        break block4;
                    }
                    catch (Exception exception) {
                    }
                    catch (b b2) {
                        break block5;
                    }
                    catch (a a2) {
                        break block6;
                    }
                    APIChecker.logExecutionException(string, exception);
                    break block4;
                }
                APIChecker.logSdkNotEnabled(string);
                break block4;
            }
            APIChecker.logSdkNotBuilt(string);
        }
    }

    public static void checkBuilt(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        block3: {
            String string;
            block4: {
                try {
                    APIChecker.checkBuilt();
                    runnable.run();
                    break block3;
                }
                catch (Exception exception) {
                }
                catch (a a2) {
                    break block4;
                }
                APIChecker.logExecutionException(string, exception);
                break block3;
            }
            APIChecker.logSdkNotBuilt(string);
        }
    }

    public static void checkEnable(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        block3: {
            String string;
            block4: {
                try {
                    APIChecker.checkEnabled();
                    runnable.run();
                    break block3;
                }
                catch (Exception exception) {
                }
                catch (b b2) {
                    break block4;
                }
                APIChecker.logExecutionException(string, exception);
                break block3;
            }
            APIChecker.logSdkNotEnabled(string);
        }
    }

    private static void checkBuilt() throws a {
        if (Instabug.isBuilt()) {
            return;
        }
        throw new a("Instabug API called before Instabug.Builder().build() was called");
    }

    private static void checkEnabled() throws b {
        if (Instabug.isEnabled()) {
            return;
        }
        throw new b("Instabug API called while Instabug SDK was disabled");
    }

    private static void logSdkNotEnabled(String apiName) {
        String string;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        InstabugSDKLogger.e("IBG-Core", String.format(NOT_ENABLED_ERROR_MESSAGE, objectArray2));
    }

    private static void logSdkNotBuilt(String apiName) {
        String string;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        InstabugSDKLogger.e("IBG-Core", String.format(NOT_BUILT_ERROR_MESSAGE, objectArray2));
    }

    private static void logMainThreadWarning(String apiName) {
        String string;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        InstabugSDKLogger.w("IBG-Core", String.format(MAIN_THREAD_ERROR_MESSAGE, objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    private static void logExecutionException(String apiName, Exception e2) {
        void var1_1;
        String string;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        InstabugSDKLogger.e("IBG-Core", String.format(NOT_EXECUTED_ERROR_MESSAGE, objectArray2) + " due to" + var1_1.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$checkAndRunOrThrow$4(VoidRunnable runnable, String apiName) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            void var1_1;
            APIChecker.logExecutionException((String)var1_1, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$checkAndRunInExecutorThenPostOnMain$3(VoidRunnable runnable, String apiName) {
        block4: {
            void var1_2;
            block6: {
                block5: {
                    try {
                        APIChecker.checkBuilt();
                        APIChecker.checkEnabled();
                        PoolProvider.postMainThreadTask(() -> {
                            try {
                                runnable.run();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        });
                        break block4;
                    }
                    catch (Exception exception) {
                    }
                    catch (b b2) {
                        break block5;
                    }
                    catch (a a2) {
                        break block6;
                    }
                    APIChecker.logExecutionException((String)var1_2, exception);
                    break block4;
                }
                APIChecker.logSdkNotEnabled((String)var1_2);
                break block4;
            }
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$checkAndRunInExecutor$1(VoidRunnable runnable, String apiName) {
        block4: {
            void var1_2;
            block6: {
                block5: {
                    try {
                        APIChecker.checkBuilt();
                        APIChecker.checkEnabled();
                        runnable.run();
                        break block4;
                    }
                    catch (Exception exception) {
                    }
                    catch (b b2) {
                        break block5;
                    }
                    catch (a a2) {
                        break block6;
                    }
                    APIChecker.logExecutionException((String)var1_2, exception);
                    break block4;
                }
                APIChecker.logSdkNotEnabled((String)var1_2);
                break block4;
            }
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$checkAndGet$0(ReturnableRunnable runnable, String apiName, Object fallbackValue) {
        void var2_3;
        block6: {
            void var1_2;
            block5: {
                block4: {
                    try {
                        APIChecker.checkBuilt();
                        APIChecker.checkEnabled();
                        return runnable.run();
                    }
                    catch (Exception exception) {
                    }
                    catch (b b2) {
                        break block4;
                    }
                    catch (a a2) {
                        break block5;
                    }
                    APIChecker.logExecutionException((String)var1_2, exception);
                    break block6;
                }
                APIChecker.logSdkNotEnabled((String)var1_2);
                break block6;
            }
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
        return var2_3;
    }
}

