@file:JvmName("CtxKt")

package com.instabug.library.util.extenstions

import android.content.Context
import com.instabug.library.util.ParameterizedLazy
import com.instabug.library.util.parameterizedNullRetryLazy
import java.io.File

private val externalFilesDirHolder: ParameterizedLazy<Context, File?> =
    parameterizedNullRetryLazy { ctx -> ctx.getExternalFilesDir(null) }

val Context.externalFilesDir: File?
    get() = externalFilesDirHolder.get(this)

private val internalFilesDirHolder: ParameterizedLazy<Context, File> =
    parameterizedNullRetryLazy { ctx -> ctx.filesDir }

val Context.internalFilesDir: File
    get() = internalFilesDirHolder.get(this)