package com.instabug.library.util

import android.content.Context
import android.content.res.Resources
import android.graphics.drawable.Drawable
import android.os.Build
import androidx.annotation.DrawableRes
import androidx.core.content.ContextCompat
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat
import com.instabug.library.R

/**
 * Created by Barakat on 24/09/2019
 */
object ResourcesUtils {
    /**
     * Get a drawable from vector with AppCompat backward compatibility
     *
     * @param resourceId to be loaded
     * @param context  to resolve teh resources
     *
     * @return drawable
     */
    @JvmStatic
    fun getVectorDrawable(@DrawableRes resourceId: Int, context: Context): Drawable? =
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) VectorDrawableCompat.create(
            context.resources,
            resourceId,
            context.theme
        ) else
            context.resources.getDrawable(resourceId, context.theme)

    /**
     * Get a drawable from png with AppCompat backward compatibility
     *
     * @param resourceId to be loaded
     * @param context  to resolve teh resources
     *
     * @return drawable
     */
    @JvmStatic
    fun getDrawable(@DrawableRes resourceId: Int, context: Context): Drawable? =
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP)
            ContextCompat.getDrawable(context, resourceId)
        else
            context.resources.getDrawable(resourceId, context.theme)

    @JvmStatic
    fun Resources.getSelectedText(isSelected: Boolean): String =
        if (isSelected) getString(R.string.ib_selected) else getString(R.string.ib_unselected)
}