package com.instabug.library.sessionprofiler.model.timeline;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by tarek on 3/4/18.
 */

public class MemoryUsage extends TimelinePoint {

    public final static String KEY_TOTAL = "total";

    private long value;
    private long totalMemory;

    public MemoryUsage(long value) {
        this.value = value;
    }

    public MemoryUsage(long value, long totalMemory) {
        this.value = value;
        this.totalMemory = totalMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getValue() {
        return value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = getTimelinePointJSONObject(value);
        if (totalMemory > 0) {
            jsonObject.put(KEY_TOTAL, totalMemory);
        }
        return jsonObject;
    }

    private static MemoryUsage fromJSONObject(JSONObject jsonObject) throws JSONException {
        MemoryUsage memoryUsage = new MemoryUsage(jsonObject.getLong(KEY_VALUE));
        if (jsonObject.has(KEY_TOTAL)) {
            memoryUsage.setTotalMemory(jsonObject.getLong(KEY_TOTAL));
        }
        memoryUsage.setTime(jsonObject.getDouble(KEY_TIME));
        return memoryUsage;
    }

    static Queue<TimelinePoint> fromJSONArray(JSONArray jsonArray) throws
            JSONException {
        Queue<TimelinePoint> memoryUsages = new ConcurrentLinkedQueue<>();

        for (int i = 0; i < jsonArray.length(); i++) {
            memoryUsages.add(fromJSONObject(jsonArray.getJSONObject(i)));
        }
        return memoryUsages;
    }
}
