package com.instabug.library.sessionprofiler.model.timeline;

import androidx.annotation.Nullable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by tarek on 3/4/18.
 */

public class ConnectivityState extends TimelinePoint {

    private final static String KEY_NAME = "name";

    public final static String KEY_WIFI = "WiFi";
    public final static String KEY_CELLULAR = "Cellular";
    public final static String KEY_NO_CONNECTION = "no_connection";

    @Nullable
    private String value;
    @Nullable
    private String name;

    @Nullable
    public String getValue() {
        return value;
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {

        JSONObject jsonObject = getTimelinePointJSONObject(value);
        if (name != null) {
            jsonObject.put(KEY_NAME, name);
        }
        return jsonObject;
    }

    private static ConnectivityState fromJSONObject(JSONObject jsonObject) throws JSONException {
        ConnectivityState connectivityState = new ConnectivityState();
        connectivityState.setTime(jsonObject.getDouble(KEY_TIME));
        connectivityState.setValue(jsonObject.getString(KEY_VALUE));
        if (jsonObject.has(KEY_NAME)) {
            connectivityState.setName(jsonObject.getString(KEY_NAME));
        }
        return connectivityState;
    }

    static Queue<TimelinePoint> fromJSONArray(JSONArray jsonArray) throws
            JSONException {
        Queue<TimelinePoint> connectivityStates = new ConcurrentLinkedQueue<>();

        for (int i = 0; i < jsonArray.length(); i++) {
            connectivityStates.add(fromJSONObject(jsonArray.getJSONObject(i)));
        }
        return connectivityStates;
    }
}
