package com.instabug.library.screenshot.instacapture

import com.instabug.library.MaskingType

interface UserMaskingFilterProvider {
    /**
     * a filter which will be used to mask the types entered by the user
     * @return empty list if the user didn't specify masking filters
     * or called the api without any arguments
     * or called the api with {@link MaskingType#MASK_NOTHING}
     */
    val userMaskingFilters: List<ViewsFilter>

    /**
     * sets the masking types needed to create the user views filters
     * @see ViewsFilter
     * */
    fun setAutoMaskScreenshotsTypes(@MaskingType vararg types: Int)
}


object UserMaskingFilterProviderImpl : UserMaskingFilterProvider {

    override var userMaskingFilters: List<ViewsFilter> = emptyList()
        private set

    override fun setAutoMaskScreenshotsTypes(@MaskingType vararg types: Int) {
        userMaskingFilters = types.toSet()
            .takeUnless { typesSet -> typesSet.shouldMaskNothing }
            ?.mapNotNull { type -> type.asViewsFilterType }
            ?.mapNotNull(ViewsFilter::fromViewsFilterType)
            .orEmpty()
    }

    private val Collection<Int>.shouldMaskNothing
        get() = all { type -> type == MaskingType.MASK_NOTHING }

    private val Int.asViewsFilterType: Int?
        get() = when (this) {
            MaskingType.TEXT_INPUTS -> ViewsFilterTypes.INPUT
            MaskingType.LABELS -> ViewsFilterTypes.LABELS
            MaskingType.MEDIA -> ViewsFilterTypes.MEDIA
            else -> null
        }
}
