package com.instabug.library.networkDiagnostics.configuration

import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.networkDiagnostics.NetworkDiagnosticsConstants
import com.instabug.library.networkDiagnostics.NetworkDiagnosticsConstants.NETWORK_DIAGNOSTICS_KEY
import org.json.JSONObject

interface NetworkDiagnosticsConfigurationHandler {

    fun handle(response: JSONObject)
}

class NetworkDiagnosticsConfigurationHandlerImpl : NetworkDiagnosticsConfigurationHandler {
    override fun handle(response: JSONObject) {
        val networkDiagnosticsEnabled = response.optBoolean(
            NETWORK_DIAGNOSTICS_KEY,
            NetworkDiagnosticsConstants.Defaults.NETWORK_DIAGNOSTICS_FALLBACK_KEY_MISSING
        )
        CoreServiceLocator.networkDiagnosticsConfigurationProvider.networkDiagnosticsEnabled =
            networkDiagnosticsEnabled

        if (!networkDiagnosticsEnabled) {
            CoreServiceLocator.networkDiagnosticsManager.onNetworkDiagnosticsCallbacksDisabled()
        }
    }

}