package com.instabug.library.networkDiagnostics

object NetworkDiagnosticsConstants {
    const val NETWORK_DIAGNOSTICS_KEY = "network_diagnostics_callback"
    const val NETWORK_DIAGNOSTICS_PREFERENCES_KEY = "network_diagnostics_wrapper"

    object Defaults {
        const val NETWORK_DIAGNOSTICS_FALLBACK = true
        const val NETWORK_DIAGNOSTICS_FALLBACK_KEY_MISSING = false
    }

    object LogMessages {
         const val LOADING_CACHED_DATA = "Loading cached network diagnostics"
         const val SESSION_ENDED = "Session ended. Dumping network diagnostics to cache"
         const val TIMED_DUMPING = "Network diagnostics timed dumping to cache"
         const val REQUEST_THRESHOLD_DUMPING = "Request count threshold reached. Dumping network diagnostics to cache"
         const val CALLING_ON_READY = "Calling NetworkDiagnosticsCallback with: Date \"s1\", Total requests count \"s2\", And failed requests count \"s3\""
    }
}