package com.instabug.library.model.session;

import androidx.annotation.Keep;
import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.model.session.SessionParameter.APP_TOKEN;
import static com.instabug.library.model.session.SessionParameter.APP_VERSION;
import static com.instabug.library.model.session.SessionParameter.CRASH_REPORTING_ENABLED;
import static com.instabug.library.model.session.SessionParameter.CUSTOM_ATTRIBUTES;
import static com.instabug.library.model.session.SessionParameter.CUSTOM_ATTRIBUTES_KEYS;
import static com.instabug.library.model.session.SessionParameter.DEVICE;
import static com.instabug.library.model.session.SessionParameter.DURATION;
import static com.instabug.library.model.session.SessionParameter.OS;
import static com.instabug.library.model.session.SessionParameter.SDK_VERSION;
import static com.instabug.library.model.session.SessionParameter.STARTED_AT;
import static com.instabug.library.model.session.SessionParameter.STITCHED_SESSION_LEAD;
import static com.instabug.library.model.session.SessionParameter.USER_EMAIL;
import static com.instabug.library.model.session.SessionParameter.USER_EVENTS;
import static com.instabug.library.model.session.SessionParameter.USER_EVENTS_KEYS;
import static com.instabug.library.model.session.SessionParameter.USER_NAME;
import static com.instabug.library.model.session.SessionParameter.UUID;

@Keep
@Retention(RetentionPolicy.SOURCE)
@StringDef({OS, DEVICE, USER_NAME, USER_EMAIL, DURATION, STARTED_AT, SDK_VERSION, APP_VERSION,
        USER_EVENTS, CUSTOM_ATTRIBUTES, CRASH_REPORTING_ENABLED, UUID, APP_TOKEN, USER_EVENTS_KEYS,CUSTOM_ATTRIBUTES_KEYS,STITCHED_SESSION_LEAD })
public @interface SessionParameter {

    String OS = "os";
    String UUID = "uuid";
    String DEVICE = "device";
    String USER_NAME = "name";
    String USER_EMAIL = "email";
    String DURATION = "duration";
    String STARTED_AT = "started_at";
    String SDK_VERSION = "sdk_version";
    String APP_VERSION = "app_version";
    String USER_EVENTS = "user_events";
    String USER_EVENTS_KEYS = "user_event_keys";
    String APP_TOKEN = "application_token";
    String CUSTOM_ATTRIBUTES = "custom_attributes";
    String CUSTOM_ATTRIBUTES_KEYS = "custom_attribute_keys";
    String CRASH_REPORTING_ENABLED = "crash_reporting_enabled";
    String STITCHED_SESSION_LEAD = "stitched_session_lead";
}
