package com.instabug.library.internal.storage.cache.dbv2

fun IBGDbManager.kQuery(
    table: String,
    columns: Array<String>? = null,
    groupBy: String? = null,
    having: String? = null,
    orderBy: String? = null,
    limit: String? = null,
    whereClause: WhereClause? = null
): IBGCursor? = query(
    table,
    columns,
    whereClause?.selection,
    whereClause?.args,
    groupBy,
    having,
    orderBy,
    limit
)

fun IBGDbManager.kDelete(
    table: String,
    selection: String? = null,
    selectionArgs: List<IBGWhereArg>? = null,
) = delete(
    table,
    selection,
    selectionArgs
)

infix fun String.and(where: String?) = this + (where
    ?.let { "And $where" }
    ?: "")
typealias WhereClause = Pair<String, List<IBGWhereArg>>

fun List<String>.asArgs(transitive:Boolean=true) = map { arg -> IBGWhereArg(arg,transitive) }

fun <T> List<T>.joinToArgs() = joinToString(
    prefix = "(",
    postfix = ")"
) { "?" }

val WhereClause.selection
    get() = first
val WhereClause.args
    get() = second