package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.BOOLEAN_TYPE
import com.instabug.library.diagnostics.diagnostics_db.TEXT_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE

class Migration_50_51 : Migration {

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addAPMNetworkLogW3cExternalTraceIdColumns()
            addDanglingAPMNetworkLogW3cExternalTraceIdColumns()
        }
    }

    private fun SQLiteDatabase.addAPMNetworkLogW3cExternalTraceIdColumns() {
        execSQL("ALTER TABLE ${InstabugDbContract.APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.APMNetworkLogEntry.COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED} $BOOLEAN_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.APMNetworkLogEntry.COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID} $INTEGER_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.APMNetworkLogEntry.COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP} $INTEGER_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.APMNetworkLogEntry.COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID} $TEXT_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.APMNetworkLogEntry.COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID} $TEXT_TYPE DEFAULT NULL")
    }

    private fun SQLiteDatabase.addDanglingAPMNetworkLogW3cExternalTraceIdColumns() {
        execSQL("ALTER TABLE ${InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_IS_W3C_EXTERNAL_NETWORK_TRACE_ID_CAPTURED} $BOOLEAN_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_PID} $INTEGER_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_W3C_EXTERNAL_NETWORK_TRACE_ID_TIMESTAMP} $INTEGER_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_GENERATED_W3C_EXTERNAL_NETWORK_TRACE_ID} $TEXT_TYPE DEFAULT NULL")
        execSQL("ALTER TABLE ${InstabugDbContract.DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${InstabugDbContract.DanglingAPMNetworkLogEntry.COLUMN_CAPTURED_W3C_EXTERNAL_NETWORK_TRACE_ID} $TEXT_TYPE DEFAULT NULL")
    }
}