package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.storage.cache.user.UserCacheManager;
import com.instabug.library.settings.SettingsManager;

public class MigrateUserSessionsCountAction implements Action {

    private final String uuid;

    public MigrateUserSessionsCountAction(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        int sessionCount = SettingsManager.getInstance().getSessionsCount() +
                UserCacheManager.getUserSessionCount(uuid);
        UserCacheManager.insertUser(uuid, sessionCount);
        SettingsManager.getInstance().updateUserSessionCount(sessionCount);
    }
}
