package com.instabug.library.internal.layer;

import android.graphics.Bitmap;
import android.graphics.Canvas;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.Nullable;

public abstract class LayerProvider {

    @Nullable
    public Bitmap bitmap;

    public abstract void prepare(final OnPrepareDoneCallback callback);
    public abstract void prepareVideoFrame(final OnPrepareDoneCallback callback);

    public boolean shouldDraw() {
        if (bitmap != null && bitmap.getHeight() > 0 && bitmap.getWidth() > 0) {
            InstabugSDKLogger.v(Constants.LOG_TAG, "LayerView bitmap width and height > 0, should draw it");
            return true;
        } else {
            InstabugSDKLogger.v(Constants.LOG_TAG, "LayerView bitmap width and height == 0, should NOT draw it");
            return false;
        }
    }

    public abstract void draw(Canvas canvas);

    public abstract boolean isValid();

    public abstract Object getView();

    public interface OnPrepareDoneCallback {

        void onPrepareDone();
        void onPrepareDoneForVideo();
    }

}
