package com.instabug.library.internal.layer;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import java.lang.ref.WeakReference;

public class CapturableViewLayerProvider extends LayerProvider {

    private WeakReference<CapturableView> capturableViewWeakReference;

    public CapturableViewLayerProvider(CapturableView capturableView) {
        capturableViewWeakReference = new WeakReference<>(capturableView);
    }

    @Override
    public void prepare(final OnPrepareDoneCallback callback) {
        CapturableView capturableView = null;

        if (capturableViewWeakReference != null && capturableViewWeakReference.get() != null) {
            capturableView = capturableViewWeakReference.get();
        } else {
            callback.onPrepareDone();
        }

        if (capturableView != null) {
            if (!capturableView.isVisible()) {
                callback.onPrepareDone();
            }

            capturableView.snapshot(new CapturableView.SnapshotPreparationCallback
                    () {
                @Override
                public void onSnapshotReady(Bitmap bitmap) {
                    CapturableViewLayerProvider.super.bitmap = bitmap;
                    callback.onPrepareDone();
                }

                @Override
                public void onSnapshotFailed() {
                    callback.onPrepareDone();
                }
            });
        }
    }

    @Override
    public void prepareVideoFrame(final OnPrepareDoneCallback callback) {
        CapturableView capturableView = null;

        if (capturableViewWeakReference != null && capturableViewWeakReference.get() != null) {
            capturableView = capturableViewWeakReference.get();
        } else {
            callback.onPrepareDoneForVideo();
        }

        if (capturableView != null) {
            if (!capturableView.isVisible()) {
                callback.onPrepareDoneForVideo();
            }

            capturableView.snapshot(new CapturableView.SnapshotPreparationCallback
                    () {
                @Override
                public void onSnapshotReady(Bitmap bitmap) {
                    CapturableViewLayerProvider.super.bitmap = bitmap;
                    callback.onPrepareDoneForVideo();
                }

                @Override
                public void onSnapshotFailed() {
                    callback.onPrepareDoneForVideo();
                }
            });
        }
    }

    @Override
    public void draw(Canvas canvas) {
        if (shouldDraw()) {
            final int[] location = new int[2];
            CapturableView capturableView = null;

            if (capturableViewWeakReference != null && capturableViewWeakReference.get() != null) {
                capturableView = capturableViewWeakReference.get();
                if (capturableView != null) {
                    capturableView.getLocationOnScreen(location);
                }
            }
            //canvas.drawBitmap(bitmap, location[0], location[1], null);
        }
    }

    @Override
    public boolean isValid() {
        CapturableView capturableView = null;

        if (capturableViewWeakReference != null && capturableViewWeakReference.get() != null) {
            capturableView = capturableViewWeakReference.get();

            if (capturableView != null) {
                if (capturableView.isVisible()) {
                    InstabugSDKLogger.w(Constants.LOG_TAG, "Capturable view reference no longer exists. " +
                            "Skipping.");

                    return false;
                }
                InstabugSDKLogger.v(Constants.LOG_TAG, "Capturable view reference still valid! - " +
                        capturableView + " - " + capturableView
                        .isVisible());
            }
        }
        return true;
    }

    @Override
    @Nullable
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION")
    public Object getView() {
        if (capturableViewWeakReference == null) {
            return null;
        }
        return capturableViewWeakReference.get();
    }
}
