package com.instabug.library.internal.dataretention.files.logs;

import com.instabug.library.internal.dataretention.files.FileRecord;
import com.instabug.library.logging.disklogs.LogFilesHelper;
import com.instabug.library.util.TimeUtils;

import java.io.File;

import androidx.annotation.NonNull;

public class LogFileRecord extends FileRecord {

    public LogFileRecord(@NonNull File file) {
        super(file);
    }

    @Override
    public long getAge() {
        long timeStamp = LogFilesHelper.getTimeStampFromFileName(get());
        return timeStamp == -1 ? super.getAge() : TimeUtils.currentTimeMillis() - timeStamp;
    }
}
