package com.instabug.library.interactionstracking

import android.view.View

/**
 * An abstract contract for transformers.
 * The core purpose of a transformer is to transform an actual UI representation (View, LayoutNode, etc ...)
 * to a standard UI node representation [IBGUINode]
 */
fun interface UINodeTransformer<In> {
    /**
     * Transforms a given origin representation to a standard [IBGUINode] representation.
     * @param origin the original representation of the UI.
     * @return a standard IBG representation of the UI.
     */
    fun transform(origin: In): IBGUINode
}

/**
 * A concrete implementation of [UINodeTransformer] that transforms only Legacy [View] UI components.
 */
val LegacyViewUINodeTransformer = object : UINodeTransformer<View> {
    override fun transform(origin: View): IBGUINode =
        IBGLegacyViewUINode(origin, this)
}