package com.instabug.library.diagnostics.sdkEvents.cache

import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent

internal interface SDKEventsDbHelper {

    /*
    * if the event isn't stored in the database it stores it with its count
    * else it increments the stored count with the new value
    */
    fun insertOrUpdateEvent(event: SDKEvent)

    /*
    * fetches all events from the database
    * returns null if the table is empty
    */
    fun queryAllEvents(): List<SDKEvent>?

    /*
    * deletes every event in the collection if it has a table entry
    */
    fun deleteManyEvents(keys: Collection<String>?)

    /*
    * clear sdk_events table
    */
    fun deleteAllEvents()

    /*
    * subtracts synced counts from the database and update subtracted values
    */
    fun updateSyncedRecords(syncedEvents: List<SDKEvent>)

    /*
    * delete events with count = 0
    */
    fun deleteZeroCountedEvents()
}