package com.instabug.library.diagnostics.diagnostics_db.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.DB_V2
import com.instabug.library.diagnostics.diagnostics_db.NonFatalEntry
import com.instabug.library.diagnostics.diagnostics_db.NonFatalOccurrenceEntry
import com.instabug.library.internal.storage.cache.dbv2.migration.BaseDBMigrationImpl
import com.instabug.library.internal.storage.cache.dbv2.migration.BaseDbMigration

class DiagnosticsDBMigrationV2(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration?
        get() = null
    override val version: Int
        get() = DB_V2

    override fun execute() = runLogic {
        db.execSQL(NonFatalEntry.CREATE_TABLE)
        db.execSQL(NonFatalOccurrenceEntry.CREATE_TABLE)
    }
}