package com.instabug.library.core.eventbus

import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable
import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus
import com.instabug.library.tracking.ActivityLifeCycleEvent

object CurrentActivityLifeCycleEventBus : InstabugEventBus<ActivityLifeCycleEvent>()
interface ActivityLifecycleSubscriber {
    fun subscribe()
    fun unsubscribe()
}
class ActivityLifecycleSubscriberImpl(
    private val eventsHandler: DefaultActivityLifeCycleEventHandler
) : ActivityLifecycleSubscriber {

    private var disposable: IBGDisposable? = null
    override fun subscribe() = synchronized(this) {
        disposable = disposable ?: CurrentActivityLifeCycleEventBus.subscribe(::handleEvent)
    }

    private fun handleEvent(lifeCycleEvent: ActivityLifeCycleEvent) = with(eventsHandler) {
        when (lifeCycleEvent) {
            ActivityLifeCycleEvent.STARTED -> handleActivityStarted()
            ActivityLifeCycleEvent.CREATED -> handleActivityCreated()
            ActivityLifeCycleEvent.RESUMED -> handleActivityResumed()
            ActivityLifeCycleEvent.PAUSED -> handleActivityPaused()
            ActivityLifeCycleEvent.STOPPED -> handleActivityStopped()
            ActivityLifeCycleEvent.DESTROYED -> handleActivityDestroyed()
        }
    }

    override fun unsubscribe() = synchronized(this) {
        disposable?.dispose()
        disposable = null
    }
}