package com.instabug.library.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class LastContactedChangedBroadcast extends BroadcastReceiver {
    //Public static String represent onLastContactedAtChanged action for local broadcasts.
    public static final String LAST_CONTACTED_CHANGED = "User last contact at changed";
    //Public static String key for last contacted at value (long format).
    public static final String LAST_CONTACTED_AT = "last_contacted_at";
    /**
     * LastContactedMonitor {@link LastContactedChangedBroadcast.LastContactedMonitor} instance received from caller.
     * Using in notifying caller when lastContactedAt changed.
     */
    private LastContactedMonitor mLastContactedMonitor;

    public LastContactedChangedBroadcast(LastContactedMonitor mLastContactedMonitor) {

        this.mLastContactedMonitor = mLastContactedMonitor;

    }

    /**
     * This method is called when the BroadcastReceiver is receiving an Intent broadcast.
     * <p/>
     *
     * @param context The Context in which the receiver is running.
     * @param intent  The Intent being received.
     */
    //[START - on_receive]
    @Override
    public void onReceive(Context context, Intent intent) {
        InstabugSDKLogger.v(Constants.LOG_TAG, "LastContactedChangedBroadcast onReceive");
        mLastContactedMonitor.onLastContactedAtChanged();

    }//[END - on_receive]

    public interface LastContactedMonitor {

        void onLastContactedAtChanged();

    }
}
