package com.instabug.library.util;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;

/**
 * Created by Tarek360 on 2/27/17.
 */

public class StringUtility {

    public static final String ELLIPSIZE = "…";


    public static String trimString(String s) {
        return trimString(s, 4096);
    }

    public static String trimString(String s, int limit) {
        if (s == null) {
            return "null";
        }

        if (s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    public static String[] trimStrings(String[] strings) {
        for (int i = 0; i < strings.length; i++) {
            strings[i] = trimString(strings[i]);
        }
        return strings;
    }

    public static boolean isNumeric(String s) {
        return s.matches("\\d+(?:\\.\\d+)?");
    }

    public static int compareVersion(String version1, String version2) throws NumberFormatException {
        String[] arr1 = version1.split("\\.");
        String[] arr2 = version2.split("\\.");
        int i = 0;
        while (i < arr1.length || i < arr2.length) {
            if (i < arr1.length && i < arr2.length) {
                if (Integer.parseInt(arr1[i]) < Integer.parseInt(arr2[i])) {
                    return -1;
                } else if (Integer.parseInt(arr1[i]) > Integer.parseInt(arr2[i])) {
                    return 1;
                }
            } else if (i < arr1.length) {
                if (Integer.parseInt(arr1[i]) != 0) {
                    return 1;
                }
            } else if (i < arr2.length) {
                if (Integer.parseInt(arr2[i]) != 0) {
                    return -1;
                }
            }
            i++;
        }
        return 0;
    }

    public static String removeExtension(String fileName) {
        return fileName.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        if (strings == null || strings.size() == 0)
            return sb.toString();
        for (int i = 0; i < strings.size() - 1; i++) {
            sb.append(strings.get(i));
            sb.append(",");
        }
        sb.append(strings.get(strings.size() - 1));
        return sb.toString();
    }

    @Nullable
    public static String applyDoubleQuotations(@Nullable String s) {
        if (s == null || s.trim().length() == 0) return s;
        if (!s.startsWith("\"")) s = "\"" + s + "\"";
        return s;
    }

    public static String ellipsize(String str, @IntRange(from = 0) int limit) {
        if (str != null && str.trim().length() > limit) {
            str = str.trim().substring(0, limit) + ELLIPSIZE;
        }
        return str;
    }

    public static String formatOOMExceptionMessage(String failingOperationName) {
        return String.format("An OOM error occurred while %s.", failingOperationName);
    }

    /**
     * Create a regex format as a string object for the given url that will be match the actual
     * url later at runtime if it's dynamicPart changed.
     * The \\w+ expression replace the dynamicPart of the url with any other literal path
     *
     * @param url         that will be used to create the regex for it.
     * @param dynamicPart of the url that will be replace by regex to be matched at runtime.
     * @return A string regex format for the given url.
     */
    public static String getRegexFormatForUrl(@NonNull String url, @Nullable String dynamicPart) {
        String formattedUrl = url;

        if (dynamicPart != null)
            formattedUrl = url.replace(dynamicPart, "\\w+");

        return formattedUrl;
    }
    public static boolean isNullOrEmpty(@Nullable String value) {
        return value == null || value.trim().isEmpty();
    }
}
