package com.instabug.library.user;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.db.InstabugDBInsertionListener;

public class UserManagerWrapper {

    public static String getUserUUID() {
        return UserManager.getUUID();
    }

    public static String getUserEmail() {
        return UserManager.getUserEmail();
    }

    @Nullable
    public static String getUserName() {
        return UserManager.getUserName();
    }

    public static void getUUIDAsync(@NonNull InstabugDBInsertionListener<String> listener) {
        UserManager.getUUIDAsync(listener);
    }

    @Nullable
    public static String getEmailForBugReport() {
        return UserManager.getEmailForBugReport();
    }

    @NonNull
    public static String getIdentifiedUserEmail() {
        return UserManager.getIdentifiedUserEmail();
    }
}
