package com.instabug.library.tracking

/**
 * @author mhashim6 on 5/9/22
 */

interface FirstFGTimeProvider {
    val firstFGTime: Long?

    object Factory {
        operator fun invoke(): FirstFGTimeProvider = FirstFGTimeProviderSingleton
    }
}

private object FirstFGTimeProviderSingleton :
    FirstFGTimeProvider by StartedActivitiesCounterSingleton

interface StartedActivitiesCounter : FirstFGTimeProvider {
    val count: Int

    /**
     * Gets called when a new activity is started
     */
    fun onActivityStarted()

    /**
     * Gets called when a new activity is stopped
     */
    fun onActivityStopped()
}

object StartedActivitiesCounterSingleton :
    StartedActivitiesCounter by StartedActivitiesCounterDefImpl()

internal class StartedActivitiesCounterDefImpl :
    StartedActivitiesCounter, FirstFGTimeProvider {

    override var count: Int = 0
    override fun onActivityStarted() {
        count++
        firstFGTime = System.currentTimeMillis()
    }

    override fun onActivityStopped() {
        count--
    }

    override var firstFGTime: Long? = null
        set(value) {
            if (field != null) return
            field = value
        }
}
