package com.instabug.library.sessionV3.ratingDialogDetection

import android.app.Activity
import android.os.Build
import androidx.annotation.RequiresApi

interface KeyboardEventListenerProvider {
    operator fun invoke(
        activity: Activity,
        keyboardCallback: AppRatingDialogKeyboardEventListener.KeyboardCallback
    ): AppRatingDialogKeyboardEventListener
}

class KeyboardEventListenerProviderImpl : KeyboardEventListenerProvider {
    @RequiresApi(Build.VERSION_CODES.R)
    override fun invoke(
        activity: Activity,
        keyboardCallback: AppRatingDialogKeyboardEventListener.KeyboardCallback
    ): AppRatingDialogKeyboardEventListener = AppRatingDialogKeyboardEventListener(activity, keyboardCallback)
}