package com.instabug.library.networkinterception.config

import com.instabug.library.internal.sharedpreferences.PreferencePropertyFactory
import com.instabug.library.percentagefeatures.PercentageFeature
import com.instabug.library.percentagefeatures.resolvePercentages

class NetworkInterceptionConfigurationProviderImpl(
    preferencesPropertyFactory: PreferencePropertyFactory,
) : IBGNetworkInterceptionConfigurationProvider {

    private val w3CNetworkExternalTraceIdPercentageFeatureDelegate =
        preferencesPropertyFactory.create<PercentageFeature?>(
            KEY_W3C_EXTERNAL_TRACE_ID_AVAILABLE,
            PercentageFeature()
        )
    private var w3CNetworkExternalTraceIdPercentageFeature: PercentageFeature?
        by w3CNetworkExternalTraceIdPercentageFeatureDelegate

    override fun setW3CNetworkExternalTraceIdFeatureAvailabilityPercentage(percentage: Double) {
        w3CNetworkExternalTraceIdPercentageFeature =
            w3CNetworkExternalTraceIdPercentageFeature?.apply {
                resolvePercentages(percentage)
            }
    }

    override fun isW3CNetworkExternalTraceIdEnabled(): Boolean =
        w3CNetworkExternalTraceIdPercentageFeature?.isEnabled
            ?: DEFAULT_W3C_EXTERNAL_TRACE_ID_AVAILABLE

    private val isAttachingGeneratedW3CExternalTraceIdEnabledDelegate =
        preferencesPropertyFactory.create(
            KEY_GENERATED_W3C_ATTACHING_AVAILABLE,
            DEFAULT_GENERATED_W3C_ATTACHING_AVAILABLE
        )
    override var isAttachingGeneratedW3CExternalTraceIdFeatureAvailable: Boolean
        by isAttachingGeneratedW3CExternalTraceIdEnabledDelegate
    override val isAttachingGeneratedW3CExternalTraceIdEnabled: Boolean
        get() = isAttachingGeneratedW3CExternalTraceIdFeatureAvailable &&
                isW3CNetworkExternalTraceIdEnabled()

    private val isAttachingCapturedW3CExternalTraceIdEnabledDelegate =
        preferencesPropertyFactory.create(
            KEY_CAPTURED_W3C_ATTACHING_AVAILABLE,
            DEFAULT_CAPTURED_W3C_ATTACHING_AVAILABLE
        )
    override var isAttachingCapturedW3CExternalTraceIdFeatureAvailable: Boolean
        by isAttachingCapturedW3CExternalTraceIdEnabledDelegate
    override val isAttachingCapturedW3CExternalTraceIdEnabled: Boolean
        get() = isAttachingCapturedW3CExternalTraceIdFeatureAvailable &&
                isW3CNetworkExternalTraceIdEnabled()

    override fun reset() {
        w3CNetworkExternalTraceIdPercentageFeatureDelegate.clear()
        isAttachingGeneratedW3CExternalTraceIdEnabledDelegate.clear()
        isAttachingCapturedW3CExternalTraceIdEnabledDelegate.clear()
    }
}
