package com.instabug.library.networkinterception

import com.instabug.library.featuresflags.configs.FeatureFlagsConfigsHandler
import com.instabug.library.internal.crossplatform.CPConfigurationsProvider
import com.instabug.library.internal.sharedpreferences.corePrefFactory
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.config.NetworkInterceptionConfigurationHandler
import com.instabug.library.networkinterception.config.NetworkInterceptionConfigurationProviderImpl

object NetworkInterceptionServiceLocator {

    @JvmStatic
    val configurationProvider: IBGNetworkInterceptionConfigurationProvider by lazy {
        NetworkInterceptionConfigurationProviderImpl(corePrefFactory())
    }

    @JvmStatic
    fun configurationHandler(): FeatureFlagsConfigsHandler =
        NetworkInterceptionConfigurationHandler(configurationProvider, CPConfigurationsProvider)
}
