package com.instabug.library.model.v3Session

import com.instabug.library.core.InstabugCore
import com.instabug.library.sessionV3.configurations.IBGSessionConfigurations
import com.instabug.library.sessionV3.di.IBGSessionServiceLocator

data class IBGSessionExperiments(
    val sessionSerial: Long,
    val experiments: List<String>,
    val droppedCount: Int
) {

    companion object Factory {
        fun create(
            sessionSerial: Long,
            configurations: IBGSessionConfigurations = IBGSessionServiceLocator.sessionConfigurations
        ): IBGSessionExperiments? {
            return configurations.takeIf { it.isExperimentsEnabled }
                ?.experimentsStoreLimit
                ?.let { storeLimit ->
                    val experiments = InstabugCore.getExperiments(1f).orEmpty()
                    val isLimitReached = experiments.size > storeLimit
                    val trimmedExperiments =
                        trimExperiments(isLimitReached, experiments, storeLimit)
                    val droppedCount = getDroppedCount(isLimitReached, experiments, storeLimit)
                    IBGSessionExperiments(sessionSerial, trimmedExperiments, droppedCount)
                }
        }

        private fun getDroppedCount(
            isLimitReached: Boolean,
            experiments: List<String>,
            storeLimit: Int
        ) = if (isLimitReached) experiments.size - storeLimit else 0

        private fun trimExperiments(
            isLimitReached: Boolean,
            experiments: List<String>,
            storeLimit: Int
        ) = if (isLimitReached) experiments.takeLast(storeLimit) else experiments
    }
}