package com.instabug.library.model.session.config;

import androidx.annotation.IntDef;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.model.session.config.SessionsConfig.Defaults.MAX_SESSIONS;
import static com.instabug.library.model.session.config.SessionsConfig.Defaults.SYNC_INTERVALS;
import static com.instabug.library.model.session.config.SessionsConfig.Defaults.SYNC_MODE;

public class SessionsConfig {

    @Retention(RetentionPolicy.SOURCE)
    @IntDef({SYNC_INTERVALS, MAX_SESSIONS, SYNC_MODE})
    @interface Defaults {
        int SYNC_INTERVALS = 720;
        int MAX_SESSIONS = 10;
        int SYNC_MODE = SyncMode.BATCHING;
    }

    private final int syncIntervalsInMinutes;
    private final int maxSessionsPerRequest;
    @SyncMode
    private final int syncMode;

    static SessionsConfig createDefault() {
        return new SessionsConfig(SYNC_INTERVALS, MAX_SESSIONS, SYNC_MODE);
    }

    SessionsConfig(@IntRange(from = 0) int syncIntervalsInMinutes,
                   @IntRange(from = 1) int maxSessionsPerRequest,
                   @IntRange(from = 0) int syncMode) {
        this.syncIntervalsInMinutes = syncIntervalsInMinutes;
        this.maxSessionsPerRequest = maxSessionsPerRequest;
        this.syncMode = syncMode;
    }

    public int getSyncIntervalsInMinutes() {
        return syncIntervalsInMinutes;
    }

    public int getMaxSessionsPerRequest() {
        return maxSessionsPerRequest;
    }

    public int getSyncMode() {
        return syncMode;
    }

    @NonNull
    @Override
    public String toString() {
        return "{syncIntervalsInMinutes = " + syncIntervalsInMinutes + ", "
                + "maxSessionsPerRequest = " + maxSessionsPerRequest + ", "
                + "syncMode = " + syncMode + "}";
    }
}
